clear all;
close all;

%% Plot strip band structure

load('bandstructure_data.mat');

figure(1)
subplot2 = subplot(1,1,1);
set(subplot2,'FontSize',16,'XTick',[-pi/geom.mech.amech -2*pi/(3*geom.mech.amech) 0 2*pi/(3*geom.mech.amech) pi/geom.mech.amech],...
    'XTickLabel',{'-\pi', '-2\pi/3', '0', '2\pi/3', '\pi'});

xlim(subplot2,[-pi/geom.mech.amech pi/geom.mech.amech]); % Band structure showing the 1st cone
ylim(subplot2,[309.2e6 351.9e6]); % Band structure showing the 1st cone

bandgap = 328e6;
energy = lines_shift(Eval_mech.bands, bandgap);
yticks(linspace(310e6, 350e6, 5))

hold on;
box on;

for i=1:size(energy,1)
    plot(Eval_mech.kx, real(energy(i,:)), 'Color', 'blue', 'LineWidth', 3);
    plot(-Eval_mech.kx, real(energy(i,:)), 'Color', 'blue', 'LineWidth', 3);
end

% Physical edge state modes
colour_edge_mode = [146/256, 146/256, 146/256, 1];

plot(Eval_mech.kx, real(energy(19,:)), 'Color', colour_edge_mode, 'LineWidth', 3);
plot(-Eval_mech.kx, real(energy(19,:)), 'Color', colour_edge_mode, 'LineWidth', 3);

plot(Eval_mech.kx(25:30), real(energy(21,25:30)), 'Color', colour_edge_mode, 'LineWidth', 3);
plot(-Eval_mech.kx(25:30), real(energy(21,(25:30))), 'Color', colour_edge_mode, 'LineWidth', 3);